package com.hero.objects.modifiers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.ForceWall;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Transparent extends Modifier {

	private static String xmlID = "TRANSPARENT";

	private ArrayList<Adder> origAdders;

	public Transparent(Element root) {
		super(root, Transparent.xmlID);
	}

	@Override
	public ArrayList<Adder> getAssignedAdders() {
		ArrayList<Adder> ret = super.getAssignedAdders();
		for (int i = ret.size() - 1; i >= 0; i--) {
			Adder ad = ret.get(i);
			if (!includeAdder(ad.getXMLID())) {
				ret.remove(i);
			}
		}
		return ret;
	}

	@Override
	public ArrayList<Adder> getAvailableAdders() {
		ArrayList<Adder> ret = (ArrayList<Adder>) super.getAvailableAdders()
				.clone();
		for (int i = ret.size() - 1; i >= 0; i--) {
			Adder ad = ret.get(i);
			if (!includeAdder(ad.getXMLID())) {
				ret.remove(i);
			}
		}
		return ret;
	}

	@Override
	public String getColumn2Output() {
		String ret = "";
		ret += getAlias();
		ret += " to ";
		ArrayList<Adder> ads = getAssignedAdders();
		if (ads.size() == 0) {
			return getAlias() + " to [no types selected]";
		}
		int count = -1;
		for (Adder ad : ads) {
			count++;
			if ((count == ads.size() - 1) && (count > 0)) {
				if (count > 1) {
					ret += ", ";
				} else {
					ret += " ";
				}
				ret += "and ";
			} else if (count > 0) {
				ret += ", ";
			}
			ret += ad.getAlias();
		}
		ret += " Attacks";
		double val = getTotalValue();
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			if (ret.trim().length() > 0) {
				ret += " ";
			}
			ret += getInput();
		}
		ret = ret.trim();
		int index = 0;
		int parenCount = 0;
		while (ret.indexOf("(", index) >= 0) {
			parenCount++;
			index = ret.indexOf("(", index) + 1;
		}
		index = 0;
		while (ret.indexOf(")", index) >= 0) {
			parenCount--;
			index = ret.indexOf(")", index) + 1;
		}
		if (parenCount <= 0) {
			ret += " (";
		} else {
			ret += "; ";
		}

		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		if ((val > maxCost) && maxSet) {
			val = maxCost;
		}
		if ((val < minimumCost) && minSet) {
			val = minimumCost;
		}
		ret += getFraction(val) + ")";
		parenCount--;
		while (parenCount > 0) {
			ret += ")";
			parenCount--;
		}
		return ret;
	}

	private boolean includeAdder(String adderID) {
		if (getProgenitor() == null) {
			return false;
		}
		ForceWall pro = (ForceWall) getProgenitor();
		if (adderID.equalsIgnoreCase("PD")) {
			return (pro.getEdLevels() > 0) && (pro.getPdLevels() == 0);
		} else if (adderID.equalsIgnoreCase("ED")) {
			return (pro.getPdLevels() > 0) && (pro.getEdLevels() == 0);
		} else if (adderID.equalsIgnoreCase("MD")) {
			return ((pro.getPowdLevels() > 0) || providesFlashDefense())
					&& (pro.getMdLevels() == 0);
		} else if (adderID.equalsIgnoreCase("POWD")) {
			return ((pro.getMdLevels() > 0) || providesFlashDefense())
					&& (pro.getPowdLevels() == 0);
		} else if (adderID.equalsIgnoreCase("FLASHD")) {
			return ((pro.getMdLevels() > 0) || (pro.getPowdLevels() > 0))
					&& !providesFlashDefense();
		}
		return true;
	}

	@Override
	public String included(GenericObject o) {

        if (forceAllow()) return "";
		if (o instanceof ForceWall) {
			return "";
		} else {
			return "Transparent may only be applied to Force Walls.";
		}
	}

	@Override
	protected void init(Element element) {
		super.init(element);
		origAdders = availableAdders;
	}

	@Override
	public boolean isLimitation() {
		return false;
	}

	private boolean providesFlashDefense() {
		if (getProgenitor() == null) {
			return false;
		}
		if (getProgenitor().getAssignedAdders() == null) {
			return false;
		}
		for (Adder ad : getProgenitor().getAssignedAdders()) {
			if (ad.getXMLID().equals("FLASHDEFENSE")) {
				return ad.getLevels() > 0;
			}
		}
		return false;
	}

	@Override
	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		if (selectedOption != null) {
			for (int i = 0; i < origAdders.size(); i++) {
				Adder ad = origAdders.get(i);
				if (ad.getXMLID().equals(selectedOption.getXMLID())) {
					Adder sel = (Adder) ad.clone();
					sel.setSelected(true);
					getAssignedAdders().add(sel);
					return;
				}
			}
		}
	}
}